﻿/*
#define TRAINER // standardm. Trainer-Modus mit 1. Mio. Torpedos, ansonsten gibt´s nur 20
#define SPY     // standardm. Schiffskoordinaten am Anfang verraten, da es im Moment der Ereignishandler unter best. Umständen noch verhunzt xxx BUG xxx
*/

/*

C#-Programm: Battleship (c)2015 by www.gossmann.at
C#-Übung: T3B3
V0.9a - last mod: 01052015
 
 soll später einmal als APP umgeschrieben werden für Handys mit Kaufmöglichkeiten für mehr Torpedos, Spy-Modus, mehr Schiffe mit variabler Länge,
 größeres Grid, Musikausgabe, grafischen Schiffen, Computergegner, 2-Spielermodus über WLAN / Internet, Daisy-Cutter-Bomben mit Radius 3*3 oder je nach Wunsch,
 um Schiffe gleich auf einmal zu erledigen, bzw. größere Gebiete anzugreifen,...
 
 ---> Erweiterungsmöglichkeiten gibt´s genug

Aufgabenstellung (Zweck: WPF-Objekte kennen lernern und programmieren):
-----------------------------------------------------------------------

Angabe (c) DI Walter Taus FH Burgenland

T3B5 – Schiffe versenken
 
Implementieren Sie ein Window mit einem Grid mit 7 Zeilen und 7 Spalten. In jeder Zelle ist ein
Button. Auf dieser Fläche sind für den Spieler unsichtbar 3 Schiffe verteilt. Jedes Schiff ist 3 Zellen
groß. Durch Klick auf einen Button kann der Spieler in diese Zelle schießen. Hat er einen Treffer
gelandet wird ein entsprechendes Icon angezeigt, wenn nicht wird ein anderes Icon angezeigt.

-----------------------------------------------------------------------
 
Hauptcodes:
-----------

lg_grid-Array:

   0  = leeres Feld / kein Treffer
1..3  = Schiffscodes, welches Schiff dort positioniert ist

Schiffplatzierung läuft folgendermaßen in init_ships():
-------------------------------------------------------
 
Zufallskoordinate holen -> prüfen, ob dort schon ein Schiff ist
zufällige Ausrichtung holen (hoch, rechts, runter, links) -> prüfen, ob Spielfeldrand dabei überschritten wird, wenn Schiff so platziert wird
Koordinaten abgrasen und prüfen, ob man in ein anderes Schiff beim Platzieren reinkommt
alles ok? Schiff platzieren (anhand einer ID-Nr. in ein Array eintragen)
weitermachen, bis alle Schiffe platziert sind


BUGs behoben seit v0.98:

Schiffstrefferabfrage unter best. Umständen -> vermutlich C#-0, 1-Arraystart-Problem irgendwo - leider keine Zeit für ausgedehnte Debug-Session im Moment...
-> behoben: war Koordinate 30 als 39 gehandhabt -> Fehler im XML-Code nicht im C#

BUGs behoben seit v0.9:

-> Torpedozähler und Spiel verloren funktionierte im Normalmodus nicht korrekt (Präprozessordirektiven erweitert und anders gesetzt)

*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Battleship
{
    /// <summary>
    /// Interaktionslogik für MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {

        private const int up = 1;
        private const int right = 2;
        private const int down = 3;
        private const int left = 4;

        private static int lg_torpedos_counter         ;
        private static int lg_sunk_ship_counter        ; // hier wird die Anzahl der versenkten Schiffe festgehalten
        private static int[] lg_sunk_ships = new int[4]; // 3 Schiffe gilt es zu versenken, daher Array der Größe 4 (eben nicht 0-Start)
        private static int lg_ship_idx                 ; // Index auf getroffene Schiffe

        private static int[] lg_grid = new int     [50]; // Koordinaten werden bei 1 starten gelassen -> 0 ausdrücklich als Start vermieden wegen Berechnungen (Einfachheit) -> Array hat 50 Werte (49 bei 7*7-Schlachtfeld und C#-0)        


        public static void show_ships() // hier werden die Schiffe gezeigt (Trainer-Modus)
        {
            string s_trn         ; // dient zum Aufbau der Schiffskoordinaten
            int    lg_coord_count; //zählt die Anzahl der Koordinaten für Endstrich
            
            lg_coord_count = 0                                                                                        ; // zuerst ist keine da
            s_trn          = "Trainermodus-Verrat: Schiffe sind auf folgenden Koordinaten (Koordinate: Schiffs-Id) - "; // Modus-Spy...

            for (int x = 1; x <= 49; x++)
                {
                if (lg_grid[x] > 0)                                                                       // nur echte Schiffskoordinaten zeigen
                    {
                    lg_coord_count++                                                                    ; // Koordinaten aufzählen
                    if (lg_coord_count != 9)                                                              // solange neunte und damit letzte Koordinate nicht erreicht
                       {
                       s_trn = s_trn + Convert.ToString(x) + ": " + Convert.ToString(lg_grid[x]) + " / "; // String mit " / " ausgeben
                       }
                    else
                       {
                       s_trn = s_trn + Convert.ToString(x) + ": " + Convert.ToString(lg_grid[x]        ); // ansonsten Endstrich einsparen am Schluss
                       }
                    }
                }
            MessageBox.Show(s_trn                                                                      ); // spionierte Koordinaten ausgeben mit den Schiffen
        }

        public static void init_ships() // hier werden die Schiffe platziert
        {
            int lg_rnd_xy       ; // xy_Schiffskoordinatennummer wird hier aufgenommen

            int lg_errorbreak   ; // Sicherheitsabbruchzähler, wenn Zufallssuche steckt für Schiffsplatzierungen
            int lg_ship_id      ; // Identifikationsnummer des Schiffes (wie Kennzeichen beim Auto, um Koordinaten bei Treffern D I E S E M Schiff eindeutiz zuzuordnen)
            int lg_x            ; // Schleifenzähler für alle Anlässe
            int lg_rnd_direction; // Zufallsrichtung, in die positioniert wird

            double dbl_xy_calc  ; // zur Berechnung, ob Schiff rechts / links über den Spielfeldrand ragen würde beim Platzieren - da sind Kommawerte relevant

            // ---------------------
            // Initialisierungsteil:
            // ---------------------

            Random rnd    = new Random(); // Zufallsgenerator initialisieren
            lg_errorbreak =            0; // Sicherheitszähler initialisieren für Abbruch, wenn Zufallssuche "steckt"
            lg_ship_id    =            1; // Start mit Schiff #1

            // Schiffskoordinatennummernsystem initialisieren (Spielfelder 1 bis 49 für ein 7*7-Schlachtfeld, wo die Schiffe positioniert werden -> alles auf 0, d.h. kein Schiff dort)

            for (lg_x = 1; lg_x <= 49; lg_x++)
                {
                lg_grid[lg_x] = 0; // im Schiffskoordinatennummernsystem vermerken, dass vorerst kein Schiff drinnen ist (Wert: 0)
                }

            for (; ; ) // Laufdauer unbekannt -> Sicherheitsbreak bei 10000 vergeblichen durchläufen (dann stimmt was mit Zufallsgenerator nicht), bzw. bei 3 erfolgreich platztieren Schiffen
                {
                lg_errorbreak = lg_errorbreak + 1; // Sicherheitsabbruchzähler gleich einmal erhöhen

                if (lg_errorbreak > 10000) // 10000 vergebliche Durchlaufe?
                   {
                   break; // Sicherheitsabbruch
                   }

                lg_rnd_xy = rnd.Next(1, 50); // eine Platzierungskoordinate per Zufall holen, wo das Schiff platziert werden soll (Kandidaten liegen zwischen 1 und 49)

                if (lg_grid[lg_rnd_xy] != 0) // schon befüllt die Koordinate, dann Rest der Schleife schmeißen und weitermachen mit neuer Koordinate
                   {
                   continue                ; // ja -> sofort weitermachen ohne weiteren Code unten
                   }

                lg_rnd_direction = rnd.Next(1, 5); // Richtung in die es platziert werden soll auch per Zufall festlegen (1 Schiff braucht 3 Koordinaten, die zu diesem Zweck unten überprüft werden, ob schon was dort ist, bzw. Spielfeldrand überschritten wird)

                // Spielfeldrandtest, ob und in welche Richtung das Schiff auf der betreffenden Koordinatennummer überhaupt positioniert werden kann:

                switch (lg_rnd_direction) // prüfen, was Sache ist mit der Richtung
                       {

                       case up:                                                 // hoch darf erst ab 3. Reihe platziert werden, da ansonsten Schiff über den äußeren Spielfeldrand ragen würden

                            if (lg_rnd_xy <= 14) lg_rnd_direction = down      ; // Wert testen und wenn Schiff nach oben über den Spielfeldrand ragen würde die Richtung ändern, damit es nach unten platziert wird

                            break                                             ; // das Case-Break...

                    case right:                                                 // rechts darf nur platziert werden, wenn noch 2 übrige Spalten in diese Richtung frei sind

                        dbl_xy_calc = (double)lg_rnd_xy /            (double)7; // sieben Spielfelder gibt es
                        dbl_xy_calc = dbl_xy_calc - Math.Truncate(dbl_xy_calc); // Nachkommaanteil holen

                        if ((dbl_xy_calc > 0.8) || (dbl_xy_calc == 0))          // liegt ermittelte Koordinatennummer in den letzten beiden Spalten, dann Richtung ändern auf links
                           {
                           lg_rnd_direction = left;
                           }

                        break                                                  ; // das Case-Break...

                    case down:                                                  // runter darf nicht mehr ab der 6. Reihe platziert werden, da ansonsten Schiff über den äußeren Spielfeldrand ragen würden

                        if (lg_rnd_xy >= 36)                                    // Wert testen und wenn Schiff nach oben über den Spielfeldrand ragen würde die Richtung ändern, damit es nach unten platziert wird
                            {
                            lg_rnd_direction = up;
                            }

                        break                                                  ; // das Case-Break...

                    case left:                                                  // links darf nur platziert werden, wenn noch 2 übrige Spalten in diese Richtung frei sind

                        dbl_xy_calc = (double)lg_rnd_xy /            (double)7; // sieben Spielfelder gibt es
                        dbl_xy_calc = dbl_xy_calc - Math.Truncate(dbl_xy_calc); // Nachkommaanteil holen

                        if ((dbl_xy_calc < 0.3) && (dbl_xy_calc != 0)         ) // liegt ermittelte Koordinatennummer in den ersten beiden Spalten, dann Richtung ändern auf rechts
                           {
                           lg_rnd_direction = right;
                           }

                        break                                                 ; // das Case-Break...

                } // end switch Spielfeldrandtest und Richtungsänderung

                /* ########################################## */
                /* Koordinaten und Richtung sind jetzt geholt */
                /* ########################################## */

                switch (lg_rnd_direction) // jetzt Endtest, ob Schiffe sich kreuzen beim Platzieren -> "Drüberlegen" über ein bereits platziertes Schiff darf nicht sein (außer irgendwann mal 3D-U-Boot-Erweiterung...)
                       {

                       case up:

                            // Kollisions-Testschleife, ob anderes Schiff schon in dieser Richtung positioniert ist:
                            // Koordinaten absteigend über die gesamte Schiffslänge vertikal abgrasen (in 7er-Schritten, da Koordinatensystem so angelegt ist)

                            for (lg_x = lg_rnd_xy; lg_x >= lg_rnd_xy - 14; lg_x -= 7) // in 7er-Schritten herunterzählen (=für zwei verbleibende Koordinaten neben der Zufallskoordinate: 2*7 = 14)
                                {
                                if (lg_grid[lg_x] != 0)                               //  Koordinatennummer schon befüllt?
                                   {
                                   goto next_run;                                     // ja, dann neue Zufalsskoordiantennummer holen lassen (aus äußerer Schleife)
                                   }
                                }

                            // Kollisions-Testschleife überstanden (hat nicht neu iteriert), dann Schiffpositionierungsschleife ausführen

                            for (lg_x = lg_rnd_xy; lg_x >= lg_rnd_xy - 14; lg_x -= 7) // in 7er-Schritten herunterzählen (=für zwei verbleibende Koordinaten neben der Zufallskoordinate: 2*7 = 14)
                                {
                                lg_grid[lg_x] = lg_ship_id                          ; // anhand des Schiffskennzeichens vermerken, dass das Schiff jetzt darin ist
                                }                                                     // weiter bei nächster Schiffskoordinatennummer

                            break                                                   ; // das Case-Break...

                       case right:

                            // Kollisions-Testschleife, ob anderes Schiff schon in dieser Richtung positioniert ist:

                            for (lg_x = lg_rnd_xy; lg_x <= lg_rnd_xy + 2; lg_x++)     // in 1er-Schritten hochzählen (=für zwei verbleibende Koordinaten neben der Zufallskoordinate)
                                {
                                if (lg_grid[lg_x] != 0)                               // Koordinatennummer schon befüllt?
                                   {
                                   goto next_run;                                     // ja, dann neue Zufalsskoordiantennummer holen lassen (aus äußerer Schleife)
                                   }
                                }

                            // Kollisions-Testschleife überstanden (hat nicht neu iteriert), dann Schiffpositionierungsschleife ausführen

                            for (lg_x = lg_rnd_xy; lg_x <= lg_rnd_xy + 2; lg_x++)     // in 1er-Schritten hochzählen (=für zwei verbleibende Koordinaten neben der Zufallskoordinate)
                                {
                                lg_grid[lg_x] = lg_ship_id;                           // anhand des Schiffskennzeichens vermerken, dass das Schiff jetzt darin ist
                                }                                                     // weiter bei nächster Schiffskoordinatennummer

                            break                                                   ; // das Case-Break...

                       case down:

                            // Kollisions-Testschleife, ob anderes Schiff schon in dieser Richtung positioniert ist:
                            // Koordinaten aufsteigend über die gesamte Schiffslänge vertikal abgrasen (in 7er-Schritten, da Koordinatensystem so angelegt ist)

                            for (lg_x = lg_rnd_xy; lg_x <= lg_rnd_xy + 14; lg_x += 7) // in 7er-Schritten hochzählen (=für zwei verbleibende Koordinaten neben der Zufallskoordinate: 2*7 = 14)
                                {
                                if (lg_grid[lg_x] != 0)                               // Koordinatennummer schon befüllt?
                                   {
                                   goto next_run;                                     // ja, dann neue Zufalsskoordiantennummer holen lassen (aus äußerer Schleife)
                                   }
                                }

                            // Kollisions-Testschleife überstanden (hat nicht neu iteriert), dann Schiffpositionierungsschleife ausführen

                            for (lg_x = lg_rnd_xy; lg_x <= lg_rnd_xy + 14; lg_x += 7) // in 7er-Schritten hochzählen (=für zwei verbleibende Koordinaten neben der Zufallskoordinate: 2*7 = 14)
                                {
                                lg_grid[lg_x] = lg_ship_id                          ; // anhand des Schiffskennzeichens vermerken, dass das Schiff jetzt darin ist
                                }                                                     // weiter bei nächster Schiffskoordinatennummer

                                break                                               ; // das Case-Break...

                       case left:

                            // Kollisions-Testschleife, ob anderes Schiff schon in dieser Richtung positioniert ist:

                            for (lg_x = lg_rnd_xy; lg_x >= lg_rnd_xy - 2; lg_x--) // in 1er-Schritten herunterzählen (=für zwei verbleibende Koordinaten neben der Zufallskoordinate)
                                {
                                if (lg_grid[lg_x] != 0)                           // Koordinatennummer schon befüllt?
                                   {
                                   goto next_run; // ja, dann neue Zufalsskoordiantennummer holen lassen
                                   }
                                }   					                           // weiter bei nächster Schiffskoordinatennummer

                            // Kollisions-Testschleife überstanden (hat nicht neu iteriert), dann Schiffpositionierungsschleife ausführen

                            for (lg_x = lg_rnd_xy; lg_x >= lg_rnd_xy - 2; lg_x--) // in 1er-Schritten herunterzählen (=für zwei verbleibende Koordinaten neben der Zufallskoordinate)
                                {
                                lg_grid[lg_x] = lg_ship_id                      ; // anhand des Schiffskennzeichens vermerken, dass Schiff jetzt darin ist
                                }                                                 // weiter bei nächster Schiffskoordinatennummer

                             break                                              ; // das Case-Break...

                } // end switch Platzierungstest

                lg_ship_id = lg_ship_id + 1; // nächste Schiff-Id nehmen (Schiffskennzeichen, wenn wer in ein Schiff schießt und die nebeneinander sind und der dann auch das andere trifft zur korrekten Trefferzahlzuordnung für Versenkungszähler)

        next_run: // Ansprungadresse für neue Zufallskoordinate

                if (lg_ship_id > 3) break; // würde nun schon ein 4. Schiff platziert werden müssen, dann Ende (3 sind hier fürs Hausübungs-Spiel genug...)

            } // end for(;;)

        }   // end init_ships();

        // -----------------
        // Verarbeitungsteil:
        // -----------------

        public MainWindow()
        {
            int lg_x; // einen Zählindex deklarieren

            // Hauptwerte initialisieren:

// standardm. bed. Compilierung für Trainermodus:
#if TRAINER
            lg_torpedos_counter  =                     1000000; // 1 Mio. Torpedos im Trainermodus hergeben -> wenn alle verbraucht sind hat Spieler verloren, wenn Schiffe bis dahin nicht alle versenkt sind        
#else
            lg_torpedos_counter  =                          20; // 20 Torpedos im Normalmodus hergeben -> wenn alle verbraucht sind hat Spieler verloren, wenn Schiffe bis dahin nicht alle versenkt sind        
#endif
            lg_sunk_ship_counter =                           0; // am Anfang ist noch kein Schiff versenkt

            InitializeComponent                             (); // v. int. Initialisierungsroutine die Finger lassen (lassen, wie sie ist)

            for (lg_x = 0; lg_x < lg_sunk_ships.Length; lg_x++) // Trefferarray der Schiffe initialisieren - hier wird nachher die Anzahl der Treffer aufgenommen (bei 3 gilt ein Schiff als versenkt)
                {
                lg_sunk_ships[lg_x] =                        0; // zuerst ist ein Schiff intakt mit 0 Treffern
                }

            init_ships                                      (); // Schiffe platzieren lassen

// Copyright-Meldung ausgeben und Hinweise zum Programm (je nach Compilermodus für Trainer oder eben normal)
#if TRAINER
            MessageBox.Show("Battleship *** TRAINERMODE *** v0.89b\n\n(c) 2015 by www.gossmann.at\n\nclicking = firering torpedo\n\ndaneben = missed\n\nX = hit\n\nXXX = sunk\n\nyou have 1 Mio. torpedos\n\nonce all of your torpedos are depleted, you´ve lost\n\nyou win, when all 3 ships are sunk");
#else
            MessageBox.Show("Battleship v0.89b\n\n(c) 2015 by www.gossmann.at\n\nclicking = firering torpedo\n\ndaneben = missed\n\nX = hit\n\nXXX = sunk\n\nyou have 20 torpedos\n\nonce all of your torpedos are depleted, you´ve lost\n\nyou win, when all 3 ships are sunk");
#endif

// Meldung ausgeben mit den Schiffskoordinaten (Schummelmodus, wenn Compiler-Directive dafür gesetzt, was standardm. der Fall ist)
#if SPY
            show_ships(); // zeigt, dass die Schiffe korrekt positioniert sind - Ereignishandler verhaut es aber irgendwo mit dem Treffen unter best. Umständen (BUG) XXX
#endif
        } // end MainWindow()

        // ----------------------------------------------------------------------------------------------------------------------------------------------
        // Ereignishandler für die Grid-Knöpfe (der prüft, ob hinter einem Knopf im korrespondierenden Array ein Schiff steckt und reagiert etsprechend):
        // ----------------------------------------------------------------------------------------------------------------------------------------------

        private void hdl_hitcheck(object sender, RoutedEventArgs e) // wird so von Visual C# geliefert...
        {
            Button b            = (Button)sender; // den jeweiligen Zielkoordinatenknopf ermitteln
            int    lg_tmp                       ; // eine Allzweckvariable für schnelle Zwischenspeicherung von Werten
            int    lg_target_xy =              0; // für den Adressierungsindex in das Schiffskoordinatenarray wird ein Integer gebraucht
            string s_bt_content                 ; // zur Konvertierung der Koordinaten der Grid-Knöpfe, da das wie da unten nicht geht...

            s_bt_content = Convert.ToString(b.Content); // Konvertierung durchführen

            // in echte Koordinate aber nur konvertieren, wenn dort tatsächluch auch eine Nummer steht - ansonsten wurde schon dort hingefeuert (ob getroffen oder nicht)
            if ((s_bt_content != "X") && (s_bt_content != "daneben")) // steht noch eine Koordinatennummer im Grid?
               {
               lg_target_xy = Convert.ToInt32(s_bt_content         ); // ja, dann den String aus der Zielkoordinate vom Button in den Integer umwandeln
               }

            lg_torpedos_counter = lg_torpedos_counter - 1           ; // auf jeden Fall wird aber pro Aufruf des Ereignishandlers ein Torpedo abgezogen, da ja "geschossen" wurde durch Klick (auch´wenn unnötig verschossen)

            if (s_bt_content == "X")                                                                                                                         // wurde auf der entsprechenden Koordinate schon ein Schiff getroffen?
               {
               MessageBox.Show("Einmal treffen reicht... Sie haben einen Torpedo für nichts verschwendet und haben jetzt nur noch: " + lg_torpedos_counter); // ja, Meldung machen
#if (!TRAINER)
               goto lb_check_torpedos                                                                                                                      ; // in Normalmodus zum Torpedocheck, wo allenfalls beendet wird, wenn keine mehr vorhanden sind
#else
               return                                                                                                                                      ; // Ereignishandler beenden an der Stelle im Trainermodus
#endif
               }

            if (s_bt_content == "daneben") // wurde auf der entsprechenden Koordinate schon daneben geschossen?
               {
               MessageBox.Show("Sie haben doch dort schon ins Leere geschossen... Sie haben einen Torpedo für nichts verschwendet und haben jetzt nur noch: " + lg_torpedos_counter); // ja, Meldung machen
#if (!TRAINER)
               goto lb_check_torpedos                                                                                                                      ; // in Normalmodus zum Torpedocheck, wo allenfalls beendet wird, wenn keine mehr vorhanden sind
#else
               return; // Ereignishandler beenden an der Stelle im Trainermodus
#endif
               }

            if (lg_grid[lg_target_xy] > 0)                                                                                                  // einen echten (neuen) Treffer gelandet ?
               {

               MessageBox.Show                                                                                                 ("TREFFER"); // ja -> melden
               b.Content =                                                                                                             "X"; // Treffer als "X" im Grid eintragen beim entsprechend gelieferten Button

               lg_ship_idx = lg_grid[lg_target_xy                                                                                        ]; // aus der getroffenen Koordinate die Schiffs-Id als Index holen

               // die Schiffs-Id nehmen und dort im Treffer-Array die Anzahl vermerken

               lg_tmp = lg_sunk_ships[lg_ship_idx];
               lg_tmp++;
               lg_sunk_ships[lg_ship_idx] = lg_tmp;

               if (lg_sunk_ships[lg_ship_idx] == 3                                                                                        ) // hat das betreffende Schiff drei Treffer abbekommen?
                  {

                  lg_sunk_ship_counter = lg_sunk_ship_counter +                                                                          1; // ja -> dann ist es versenkt, Versenkungszähler erhöhen

                  if (lg_sunk_ship_counter == 3                                                                                           ) // prüfen, ob schon alle versenkt wurden
                     {

                     MessageBox.Show("GRATULATION!!! Sie haben GEWONNEN und die gesamte Angriffsflotte vernichtet !!!"                   ); // ja, dann Spiel gewonnen - Meldung machen

                     // Restart-Commandos... wenn es User zu blöd wird, wird der schon das WPF-Fenster schließen...
                     System.Diagnostics.Process.Start(Application.ResourceAssembly.Location);
                     System.Windows.Application.Current.Shutdown();

                     }
                  else
                     {
                     MessageBox.Show("GLÜCKWUNSCH!!! Sie haben ein Schiff versenkt!!! Es fehlen aber noch: " + (3 - lg_sunk_ship_counter)); // nein, dann die normale Versenkungsmeldung ausgeben
                     }

                }

            } // end if (lg_grid[lg_target_xy] > 0) 

            if (lg_grid[lg_target_xy] == 0) // wurde nur ins Wasser geschossen?
               {
               b.Content =       "daneben"; // ja -> dann das auch ins Grid-Feld schreiben
               }


            
#if (!TRAINER)
        lb_check_torpedos:
            if (lg_torpedos_counter == 0)                                                                                                                                                // keine Torpedos mehr vorhanden?
               {
               MessageBox.Show("Sie haben keine Torpedos mehr übrig! Sie haben daher VERLOREN, weil nicht alle Schiffe versenkt wurden. Es fehlten noch: " + (3 - lg_sunk_ship_counter)); // Spel verlorden - Meldung machen

               // Restart-Commandos... wenn es User zu blöd wird, wird der schon das WPF-Fenster schließen...
               System.Diagnostics.Process.Start(Application.ResourceAssembly.Location);
               System.Windows.Application.Current.Shutdown();
               }
#endif
        } // end Ereignishandler

    } // end Class

} // end Namespace


