﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace t2h3
{
class tontraeger
    {

    private int    durchschnittssongdauer; // wird per GET-Accessor holbar gemacht
    private int          erscheinungsjahr; // wird auch per GET-Accessor holbar gemacht
    private int           gesamtspielzeit;
    private int                songanzahl;
    private int                         x; // Schleifenzähler -> wird hier in diversen Methoden gebraucht
    private string             albumtitel;
    private string                  genre;
    private string              interpret;

    // folgende beiden Werte per GET-Accessor abholen lassen weiter unten -> Aufbereitung erfolgt gleich nebenbei in Song_aufnehmen-Methode, was extra dafür die einzelne Methoden spart

    private song[] songs= new song[20]; // 20 Songobjekte im Tonträger kapseln (OOP-Leitgedanke), mehr als 20 werden aber nicht gespeichert...

    public tontraeger (string genre, string interpret, string albumtitel, int erscheinungsjahr) // relevanten Daten per Konstruktor setzen lassen
	     {
         this.genre            =            genre;
         this.interpret        =        interpret;
         this.albumtitel       =       albumtitel;
         this.erscheinungsjahr = erscheinungsjahr;

         // pro Tonträger sollen 20 mögliche Songs gespeichert werden -> die gleich darin kapseln, anlegen lassen und vorerst "leer" initialisieren
         // (sie schlichtweg auf "null" zu belassen würde bei "song_aufnehmen" NullReferenceException auslösen -> Initailisierung, was immer eine gute Idee ist

         // die 20 möglichen Song-Objekte nun kapseln, was dem OOP-Gedanken entspricht, nämlich Daten (und andere zugehörige Objekte) sowie Code im Gesamtobjekt halten
         for (x=0; x<songs.Length; x++)    // alle erforderlichen 20 Plätze abgrasen, damit Objekt vollständig ist
             {
             songs[x]=new song("empty",0); // Initialisierung vornehmen
             }

         }

    // hier werden sämtliche Infos zum Tonträger ausgegeben -> spez. Dinge werden in den Subklassen ausgegeben (die RPM bei den Platten u. Singles)
    public void Drucken()
         {
         Console.WriteLine("Genre\t\t\t: "              + this.genre                                                                                                                                                                      );
         Console.WriteLine("Interpret\t\t: "            + this.interpret                                                                                                                                                                  );
         Console.WriteLine("Titel\t\t\t: "              + this.albumtitel                                                                                                                                                                 );
         Console.WriteLine("Jahr\t\t\t: "               + this.erscheinungsjahr                                                                                                                                                           );
         
         // Stunden bei Gesamtspielzeit berechen lassen, bei Durschnittssongdauer darauf verzichten - könnte zwar gefährlich sein, wenn es "Stundensongs geben würde", aber später kann es immer noch geändert werden, falls doch welche kommen...
         
         Console.WriteLine("Gesamtspielzeit\t\t: "      + this.gesamtspielzeit / 3600      + "h " + ((this.gesamtspielzeit-(this.gesamtspielzeit / 3600)) / 60) + "m " + ((this.gesamtspielzeit-(this.gesamtspielzeit / 3600)) % 60) + "s");
         Console.WriteLine("Durchschnittssongdauer\t: " + this.durchschnittssongdauer / 60 + "m " + this.durchschnittssongdauer % 60 + "s\n"                                                                                              );
              
         for (x=0; x<songs.Length; x++)                                                                                             // alle 20 potentiellen Songs abgrasen für die Ausgabe
             {
             if (songs[x].Laufzeit==0)                                                                                              // liegt keine Laufzeit vor?
                {
                break                                                                                                             ; // dann liegt auch kein weiterer Song mehr vor -> breaken
                }
             if (x<9)                                                                                                               // Array startet bei 0 - hier wird wegen Ausgabeanordnung geprüft, ob zwei oder ein Leerzeichzen nach der Songnummer auszugeben ist (ab 10 würde Ausgabe verrutschen)
                {
                Console.WriteLine("Song #"+(x+1)+"  - "+songs[x].Laufzeit / 60+"m "+songs[x].Laufzeit % 60+"s\t: "+songs[x].Titel); // ansonsten Song (Nummer +1 wegen Arraystart 0) und seine Dauer ausgeben
                }
             else
                {
                Console.WriteLine("Song #"+(x+1)+" - "+songs[x].Laufzeit / 60+"m "+songs[x].Laufzeit % 60+"s\t: "+songs[x].Titel); // ansonsten Song (Nummer +1 wegen Arraystart 0) und seine Dauer ausgeben
                }
             } // end for

         } // end Drucken()

     // Songs gehören zum Tonträger und werden daher hier in der Basisklasse gekapselt genau wie die Aufnahmeroutine
     public bool song_aufnehmen (string Titel, int Laufzeit)
          {

          bool status = false; // standardm. davon ausgehen, dass Song erst eingetragen werden muss

          // gleich in der Songaufnahmeroutine die Gesamt- und Durchschnittsspielzeit mitberechnen lassen
          // -> spart die entsprechenden Methoden dafür (eine Schleife läuft sowieso über alle Songs) und da die Variablen dann schlicht und einfach per
          // GET-Accessor frei Haus abgeholt werden können...

          // Initialisierung der Statistiken...

          durchschnittssongdauer = 0;
          gesamtspielzeit        = 0;

         for (x=0; x<songs.Length; x++)                                  // alle freien 20 Plätze abgrasen
             {

             // würde der status == false-Test entfallen, würde der Song auf alle 20 Plätze eingetragen werden,
             // was zu falscher Gesamtspielzeit und Durchschnittssongdauer-Berechnung führen würde

             if ((songs[x].Laufzeit==0) && (status==false))              // Plätzchen noch frei und Song noch nicht aufgenommen? (INT abfragen (Laufzeit) geht schneller als String) - ist Laufzeit leer, dann ist auch String mit Titel irrelevant (Abfrage dafür schenken!)
                {
                songs[x].Titel    =                               Titel; // ja - Titel drin ablegen
                songs[x].Laufzeit =                            Laufzeit; // und Laufzeit ebenfalls
                gesamtspielzeit   = gesamtspielzeit + songs[x].Laufzeit; // Schleife ausnutzen und gleich Gesamtlaufzeit berechnen lassen
                status            =                                true; // positiver Eintrag ist erfolgt -> Statusflag dafür setzen, damit es Aufrufer weiß (falls dort Interesse besteht und es auch abgefragt wird...)
                songanzahl        =                                 x+1; // ab hier ist x die Anzahl der Songs am Datenträger -> da Arrays bei 0 beginnen Songanzahl+1 -> vermerken in Objektvariable
                continue                                               ; // Gesamtspielzeit unten nicht nochmals zusätzlich berechnen lassen, wäre sonst falsche -> neuen Schleifendurchlauf starten (falls schon letzter Durchgang war, wird eh beendet)
                }

             // falls Plätzchen nicht mehr frei war gehört trotzdem die Gesamtspielzeit des Tonträgers weiterhin in der Schleife berechnet
             
             gesamtspielzeit+=songs[x].Laufzeit                        ; // Schleife ausnutzen und gleich Gesamtlaufzeit berechnen lassen

             } // end for

         // am Schluss noch die Durchschnittssongdauer ermitteln (anhand der Anzahl der am Tonträger vorhandenen Songs)
         
         durchschnittssongdauer = gesamtspielzeit / songanzahl                                                       ; //Integerdivision reicht (+1, da Array bei Index 0 startet), allfälliger Rest ist wegen den zerquetschten Sekunden uninteressant - deswegen werden keine doubles genommen

         if (status == false)                                                                                          // konnte Song jetzt oben in der Schleife nicht aufgenommen werden?
            {
            Console.WriteLine("Song: " + Titel + " konnte nicht mehr aufgenommen werden - Tracklist ist schon voll!"); // ja -> melden
            }

         return status                                                                                               ; // Status an Aufrufer auch per Flag melden (true -> Eintrag erfolgt, flase -> Eintrag nicht erfolgt, da alle 20 Plätze belegt)

         } // end song_aufnehmen

    // diverse GET-Accessoren implementieren für die statistischen Werte zum jeweiligen Tonträger
    public int Durchschnittssongdauer
         {
         get {return this.durchschnittssongdauer;}
         }
    public int Gesamtspielzeit
         {
         get {return this.gesamtspielzeit       ;}
         }
    public int Songanzahl
         {
         get {return this.Songanzahl            ;}
         }
}
}
